/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.compression;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.compression.ICompression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipCompression
implements ICompression {
    public void addFileToZip(String path, File folder, ZipOutputStream zip) throws IOException {
        if (folder.isDirectory()) {
            this.addFolderToZip(path, folder, zip);
        } else {
            int len;
            byte[] buf = new byte[4096];
            FileInputStream in = new FileInputStream(folder);
            zip.putNextEntry(new ZipEntry(CompressionHelper.appendFilename(path, folder.getName())));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
        }
    }

    public void addFolderToZip(String path, File folder, ZipOutputStream zip) throws IOException {
        for (File file : folder.listFiles()) {
            this.addFileToZip(CompressionHelper.appendFilename(path, folder.getName()), file, zip);
        }
    }

    @Override
    public void compress(OutputStream fos, Collection<Map.Entry<File, String>> files, int compression) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(fos);
        zip.setLevel(compression);
        for (Map.Entry<File, String> e : files) {
            if (e.getKey().isFile()) {
                this.addFileToZip(e.getValue(), e.getKey(), zip);
                continue;
            }
            this.addFolderToZip(e.getValue(), e.getKey(), zip);
        }
        zip.flush();
        zip.close();
    }

    @Override
    public void decompress(InputStream is, Function<String, File> location) throws IOException {
        ZipEntry e;
        ZipInputStream zip = new ZipInputStream(is);
        while ((e = zip.getNextEntry()) != null) {
            int len;
            File target = location.apply(e.getName());
            if (target == null) continue;
            if (e.isDirectory()) {
                target.mkdirs();
                continue;
            }
            target.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(target);
            byte[] buffer = new byte[4096];
            while ((len = zip.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
            fos.close();
        }
        zip.close();
    }
}

